% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SoilProfileCollection.R
\docType{methods}
\name{metadata,SoilProfileCollection-method}
\alias{metadata,SoilProfileCollection-method}
\alias{metadata}
\alias{metadata<-,SoilProfileCollection-method}
\alias{metadata<-}
\title{Retrieve metadata from SoilProfileCollection}
\usage{
\S4method{metadata}{SoilProfileCollection}(object)

\S4method{metadata}{SoilProfileCollection}(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{value}{A named list (see examples)}
}
\description{
Get metadata from SoilProfileCollection. Result is a list. Two entries (aqp_df_class, depth_units) should not be edited in the metadata list directly. There are methods that facilitate changing them -- and propagating their changes throughout the collection. Otherwise, metadata list is a free-form slot used to store arbitrary information about the data, how it was collected, citations, etc.
}
\examples{

data(sp5)

# replace default metadata with itself
metadata(sp5) <- metadata(sp5)

# set new metadata attribute value
metadata(sp5)$newvalue <- 'foo'

# get metadata attribute
metadata(sp5)$newvalue

}
