% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-spatial.R
\docType{methods}
\name{initSpatial<-}
\alias{initSpatial<-}
\alias{initSpatial<-,SoilProfileCollection,ANY,ANY-method}
\alias{initSpatial<-,SoilProfileCollection,ANY,character-method}
\alias{getSpatial,SoilProfileCollection-method}
\alias{getSpatial}
\alias{coordinates,SoilProfileCollection-method}
\alias{coordinates}
\alias{coordinates<-,SoilProfileCollection,ANY-method}
\alias{coordinates<-}
\alias{coordinates<-,SoilProfileCollection,character-method}
\title{Initialize Spatial Data in a SoilProfileCollection}
\usage{
\S4method{initSpatial}{SoilProfileCollection,ANY,ANY}(object, crs = NULL) <- value

\S4method{initSpatial}{SoilProfileCollection,ANY,character}(object, crs = NULL) <- value

\S4method{getSpatial}{SoilProfileCollection}(object)

\S4method{coordinates}{SoilProfileCollection}(obj)

\S4method{coordinates}{SoilProfileCollection,ANY}(object) <- value

\S4method{coordinates}{SoilProfileCollection,character}(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{crs}{Optional: character. Representation of Coordinate Reference System as \code{"authority:code"}, integer EPSG code, WKT2019 or PROJ4 string, an sf \code{crs} or sp \code{CRS} object.}

\item{value}{A formula specifying names of columns containing geometry (x and y coordinates), or character with the column names}

\item{obj}{A SoilProfileCollection}
}
\description{
\verb{initSpatial()<-}: Set the column names containing spatial data and the corresponding coordinate reference system for a SoilProfileCollection.

\code{getSpatial()}: Get spatial data associated with a SoilProfileCollection
}
\examples{

data(sp5)

# coordinates are stored in x and y column of site
sp5$x <- rnorm(length(sp5))
sp5$y <- rnorm(length(sp5))

# coordinates takes a formula object as input
initSpatial(sp5) <- ~ x + y

# optionally specify Coordinate Reference System (crs) on left-hand side
initSpatial(sp5, crs = "OGC:CRS84") <- ~ x + y
}
\seealso{
\code{\link[=prj]{prj()}}
}
