% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pairwiseEqual}
\alias{pairwiseEqual}
\title{Calculate pairwise equivalence between sequences}
\usage{
pairwiseEqual(seq)
}
\arguments{
\item{seq}{character vector containing a DNA sequences.}
}
\value{
A logical matrix of equivalence between each entry in \code{seq}. 
          Values are \code{TRUE} when sequences are equivalent and \code{FALSE}
          when they are not.
}
\description{
\code{pairwiseEqual} determined pairwise equivalence between a pairs in a 
set of sequences, excluding ambiguous positions (Ns and gaps).
}
\examples{
# Gaps and Ns will match any character
seq <- c(A="ATGGC", B="ATGGG", C="ATGGG", D="AT--C", E="NTGGG")
d <- pairwiseEqual(seq)
rownames(d) <- colnames(d) <- seq
d

}
\seealso{
Uses \link{seqEqual} for testing equivalence between pairs.
          See \link{pairwiseDist} for generating a sequence distance matrix.
}
