% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estim_PS.R
\name{estim_PS}
\alias{estim_PS}
\title{Estimates in an admixture using Patra and Sen approach}
\usage{
estim_PS(
  samples,
  admixMod,
  method = c("fixed", "lwr.bnd", "cv"),
  c.n = 0.1 * log(log(length(samples))),
  folds = 10,
  reps = 1,
  cn.s = NULL,
  cn.length = 100,
  gridsize = 1200
)
}
\arguments{
\item{samples}{Sample to be studied.}

\item{admixMod}{An object of class \link[admix]{admix_model}, containing information about the known component distribution and its parameter(s).}

\item{method}{One of 'lwr.bnd', fixed' or 'cv': depending on whether compute some lower bound of the mixing proportion, the estimate
based on the value of 'c.n' or use cross-validation for choosing 'c.n' (tuning parameter).}

\item{c.n}{(default to NULL) A positive number for the penalization, see reference below. If NULL, equals to 0.1*log(log(n)).}

\item{folds}{(optional, default to 10) Number of folds used for cross-validation.}

\item{reps}{(optional, default to 1) Number of replications for cross-validation.}

\item{cn.s}{(optional) A sequence of 'c.n' to be used for cross-validation (vector of values). Default is equally
spaced grid of 100 values between .001 x log(log(n)) and 0.2 x log(log(n)).}

\item{cn.length}{(optional, default to 100) Number of equally spaced tuning parameter (between .001 x log(log(n)) and 0.2 x log(log(n))).
Values to search from.}

\item{gridsize}{(default to 600) Number of equally spaced points (between 0 and 1) to evaluate the distance function.
Larger values are more computationally intensive but also lead to more accurate estimates.}
}
\value{
An object of class \link[admix]{estim_PS}, containing 10 attributes: 1) the number of samples studied (1 in this case); 2) the sample
size; 3) the information about component distributions of the admixture model; 4) the estimation method 5patra and Sen here);
5) the estimated mixing weight (estimate of the unknown component proportion); 6) the estimated decontaminated CDF;
7) an object of the class 'dist.fun' (that gives the distance); 8) the tuning parameter 'c.n'; 9) the lower bound of the
estimated mixing proportion (if such an option has been chosen); 10) the number of observations.
}
\description{
Estimation of both the weight and the distribution of the unknown component in an admixture model, by Patra and Sen approach.
Remind that the admixture probability density function (pdf) l is given by
l = p*f + (1-p)*g,
where g is the known component of the two-component mixture, p is the unknown proportion of the unknown component distribution f.
More information in 'Details' below concerning the estimation method.
}
\examples{
\dontrun{
## Simulate mixture data:
mixt1 <- twoComp_mixt(n = 800, weight = 0.33,
                      comp.dist = list("gamma", "exp"),
                      comp.param = list(list("shape" = 2, "scale" = 0.5),
                                        list("rate" = 0.25)))
data1 <- get_mixture_data(mixt1)
## Define the admixture model:
admixMod1 <- admix_model(knownComp_dist = mixt1$comp.dist[[2]],
                         knownComp_param = mixt1$comp.param[[2]])
## Estimation step:
ex <- estim_PS(samples = data1, admixMod = admixMod1, method = 'fixed')
print.estim_PS(ex)
}

}
\references{
\insertRef{PatraSen2016}{admix}
}
\seealso{
\code{\link[=print.estim_PS]{print.estim_PS()}} for printing a short version of the results from this estimation method,
and \code{\link[=summary.estim_PS]{summary.estim_PS()}} for more comprehensive results.
}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
\keyword{internal}
