% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_max_flag.R
\name{derive_vars_max_flag}
\alias{derive_vars_max_flag}
\title{Creating ANLxxFL Variables To Flag The Maximum Records}
\usage{
derive_vars_max_flag(dataset, flag1 = "ANL01FL", flag2 = "ANL02FL")
}
\arguments{
\item{dataset}{Input dataset}

\item{flag1}{Flags the maximum record per subject per event per
vaccination.
\emph{Permitted value: Any variable name as a string or NULL}.

\code{NULL} denotes not to create the flag}

\item{flag2}{Flags the maximum record per subject per event for Overall

\emph{Permitted value: Any variable name as a string or NULL}.

\code{NULL} denotes not to create the flag}
}
\value{
The output dataframe with \code{ANLxxFL} flags
}
\description{
Adds Flags variables for maximum record per subject per event for overall
and per vaccination
}
\details{
This utility flags the maximum record per subject per event
per vaccination/Overall
If both parameters \code{flag1} & \code{flag2} are passed as \code{NULL} then
utility will throw error and flags will not be created.
}
\examples{
library(dplyr)
library(admiraldev)
library(admiral)
library(tibble)

input <- tribble(
  ~USUBJID, ~FAOBJ, ~FATESTCD, ~FATPTREF, ~AVAL, ~FATPT, ~PARAMCD,
  "ABC101", "REDNESS", "DIAMETER", "VACC 1", 10, "DAY 1", "DIARE",
  "ABC101", "REDNESS", "DIAMETER", "VACC 1", 7, "DAY 2", "DIARE",
  "ABC101", "REDNESS", "DIAMETER", "VACC 2", 3, "DAY 1", "DIARE",
  "ABC101", "REDNESS", "DIAMETER", "VACC 2", 8, "DAY 2", "DIARE",
  "ABC101", "FATIQUE", "SEV", "VACC 1", 1, "DAY 1", "SEVFAT",
  "ABC101", "FATIQUE", "SEV", "VACC 1", 1, "DAY 2", "SEVFAT",
  "ABC101", "FATIQUE", "SEV", "VACC 2", 2, "DAY 1", "SEVFAT",
  "ABC101", "FATIQUE", "SEV", "VACC 2", 3, "DAY 2", "SEVFAT"
)

derive_vars_max_flag(
  dataset = input,
  flag1 = "ANL01FL",
  flag2 = "ANL02FL"
)
derive_vars_max_flag(
  dataset = input,
  flag1 = NULL,
  flag2 = "ANL02FL"
)
derive_vars_max_flag(
  dataset = input,
  flag1 = "ANL01FL",
  flag2 = NULL
)

}
\seealso{
Other der_var: 
\code{\link{derive_var_aval_adis}()},
\code{\link{derive_vars_crit}()},
\code{\link{derive_vars_event_flag}()},
\code{\link{derive_vars_merged_vaccine}()},
\code{\link{derive_vars_params}()},
\code{\link{derive_vars_vaxdt}()}
}
\author{
Dhivya Kanagaraj
}
\concept{der_var}
\keyword{der_var}
