% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_dbs.R
\name{update_ted}
\alias{update_ted}
\title{Update local TED database from GitHub release}
\usage{
update_ted(
  local_sqlite_path,
  tag = NULL,
  update = FALSE,
  token = Sys.getenv("GITHUB_PAT"),
  algo = "sha256"
)
}
\arguments{
\item{local_sqlite_path}{Path to the local \code{ted.db} file.}

\item{tag}{Optional release tag. If NULL, uses latest release.}

\item{update}{Logical; if TRUE, will download the latest database
when the local copy is outdated (default: FALSE).}

\item{token}{Optional GitHub token. Defaults to \code{Sys.getenv("GITHUB_PAT")}.}

\item{algo}{Hash algorithm (default: \code{"sha256"}).}
}
\value{
Invisibly returns TRUE if up to date, FALSE if outdated.
}
\description{
Checks whether the local TED SQLite database (\code{ted.db}) is up to date
with the release on \code{SLesche/truth-effect-database} and optionally downloads
the latest version.
}
\examples{
\dontrun{
update_ted("ted.db")
update_ted("ted.db", update = TRUE)
}
}
