% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zeta.R
\name{Zeta}
\alias{Zeta}
\title{Calculation of zeta and weighted zeta score.}
\usage{
Zeta(ZscoreVal, ZseqList, SVMcurve = NULL, SVM = FALSE)
}
\arguments{
\item{ZscoreVal}{input file name.}

\item{ZseqList}{the list of bins.}

\item{SVMcurve}{SVM curves for decrease and increase direction.###not always use}

\item{SVM}{do SVM or not, default is FALSE}
}
\value{
A data.frame where zeta values for all tested knockding-down genes including positive and negative controls. The first column is the direction which knockding-down gene will lead to exon inclusion, whereas the second column is the knock-down genes will lead to exon skipping.
}
\description{
This step calculates the Zeta Score based on the two curvecs. Firstly, this step provides another curve above the SVM curve to set a value to represent the regulatory function of gene i. Then, the area between the two curves (the one mentioned above and the SVM curve) is calculated as the Zeta score for this gene. Since the graph of the curves is divided into m bins, then the Zeta score can be calculated as the sum of all the bins' areas that exist between the two curves.
}
\examples{
data(ZseqList)
data(SVMcurve)
data(countMat)
data(negGene)
ZscoreVal <- Zscore(countMat,negGene)
zetaData <- Zeta(ZscoreVal,ZseqList,SVM=FALSE)

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{ZetaSuite}
\keyword{zeta}
