% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{QC}
\alias{QC}
\title{Quality control of input datasets.}
\usage{
QC(countMat, negGene, posGene)
}
\arguments{
\item{countMat}{input data set. The siRNA/gene x readouts matrix from HTS2 or large-scale RNAi screens}

\item{negGene}{negative control data set, the siRNAs/genes used as negative controls in screening.}

\item{posGene}{positive control data set, the siRNAs/genes used as positive controls in screening.}
}
\value{
A list of plots, and their names are 'score_q', 'tSNE_QC', 'QC_box' and 'QC_SSMD'. 'tSNE_QC' is the global evaluation based on all the readouts. This figure can evaluate whether the positive and negative samples are well separated based on current all readouts. And the other 3 plots are the quality evaluation of the individual readouts.
}
\description{
Quality Control (QC) is a step in evaluating the experiment design. For all two-dimension high throughput data, the t-SNE plot is firstly used to evaluate whether features are sufficient to separate positive and negative controls.
The SSMD score (See reference Zhang) is further generated for each readout to evaluate the percentage of high-quality readouts.
}
\examples{

data(countMat)
data(negGene)
data(posGene)
\donttest{QC(countMat,negGene,posGene)}

}
\references{
Laurens van der Maaten GH: Visualizing Data using t-SNE. JournalofMachineLearningResearch 2008,9(2008):2579-2605.

Zhang XD: A pair of new statistical parameters for quality control in RNA interference high-throughput screening assays. Genomics 2007, 89:552-561.
}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{ZetaSuite}
\keyword{quality}
