% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScatterHist.R
\name{ScatterHist}
\alias{ScatterHist}
\title{Plot a scatter plot with marginals.}
\usage{
ScatterHist(
  frame,
  xvar,
  yvar,
  title,
  ...,
  smoothmethod = "lm",
  estimate_sig = FALSE,
  minimal_labels = TRUE,
  binwidth_x = NULL,
  binwidth_y = NULL,
  adjust_x = 1,
  adjust_y = 1,
  point_alpha = 0.5,
  contour = FALSE,
  point_color = "black",
  hist_color = "gray",
  smoothing_color = "blue",
  density_color = "blue",
  contour_color = "blue"
)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{yvar}{name of the dependent (output or result to be modeled) column in frame}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{smoothmethod}{(optional) one of 'auto', 'loess', 'gam', 'lm', 'identity', or 'none'.}

\item{estimate_sig}{logical if TRUE and smoothmethod is 'identity' or 'lm', report goodness of fit and significance of relation.}

\item{minimal_labels}{logical drop some annotations}

\item{binwidth_x}{numeric binwidth for x histogram}

\item{binwidth_y}{numeric binwidth for y histogram}

\item{adjust_x}{numeric adjust x density plot}

\item{adjust_y}{numeric adjust y density plot}

\item{point_alpha}{numeric opaqueness of the plot points}

\item{contour}{logical if TRUE add a 2d contour plot}

\item{point_color}{color for scatter plots}

\item{hist_color}{fill color for marginal histograms}

\item{smoothing_color}{color for smoothing line}

\item{density_color}{color for marginal density plots}

\item{contour_color}{color for contour plots}
}
\value{
plot grid
}
\description{
Plot a scatter plot with optional smoothing curves or contour lines, and marginal histogram/density plots.
Based on \url{https://win-vector.com/2015/06/11/wanted-a-perfect-scatterplot-with-marginals/}.
See also \code{ggExtra::ggMarginal}.
}
\details{
If \code{smoothmethod} is:
\itemize{
\item 'auto', 'loess' or 'gam':  the appropriate smoothing curve is added to the scatterplot.
\item 'lm' (the default): the best fit line is added to the scatterplot.
\item 'identity':  the line x = y is added to the scatterplot. This is useful for comparing model predictions to true outcome.
\item 'none': no smoothing line is added to the scatterplot.
}

If \code{estimate_sig} is TRUE and \code{smoothmethod} is:
\itemize{
\item 'lm': the R-squared of the linear fit is reported.
\item  'identity': the R-squared of the exact relation between \code{xvar} and \code{yvar} is reported.
}

Note that the identity R-squared is NOT the square of the correlation between \code{xvar} and \code{yvar}
(which includes an implicit shift and scale). It is the coefficient of determination between \code{xvar} and
\code{yvar}, and can be negative. See \url{https://en.wikipedia.org/wiki/Coefficient_of_determination} for more details.
If \code{xvar} is the output of a model to predict \code{yvar}, then the identity R-squared, not the lm R-squared,
is the correct measure.

If \code{smoothmethod} is neither 'lm' or 'identity' then \code{estimate_sig} is ignored.
}
\examples{

if (requireNamespace('data.table', quietly = TRUE)) {
	# don't multi-thread during CRAN checks
		data.table::setDTthreads(1)
}

set.seed(34903490)
x = rnorm(50)
y = 0.5*x^2 + 2*x + rnorm(length(x))
frm = data.frame(x=x,y=y)
WVPlots::ScatterHist(frm, "x", "y",
  title= "Example Fit",
  smoothmethod = "gam",
  contour = TRUE)

if (FALSE) {
# Same plot with custom colors
WVPlots::ScatterHist(frm, "x", "y",
  title= "Example Fit",
  smoothmethod = "gam",
  contour = TRUE,
  point_color = "#006d2c", # dark green
  hist_color = "#6baed6", # medium blue
  smoothing_color = "#54278f", # dark purple
  density_color = "#08519c", # darker blue
  contour_color = "#9e9ac8") # lighter purple
}

}
\seealso{
\code{\link{ScatterHistC}}
}
