% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackloss.R
\name{mark_trackloss}
\alias{mark_trackloss}
\title{Mark trackloss by blink and/or screen size}
\usage{
mark_trackloss(data, Type = NULL, ScreenSize = NULL)
}
\arguments{
\item{data}{A data table object output by \code{\link{select_recorded_eye}}.}

\item{Type}{A string indicating "Blink", "OffScreen", or "Both".}

\item{ScreenSize}{A numeric vector specifying (in pixels) the dimensions
of the x and y of the screen used during the experiment.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{mark_trackloss} marks data points related to trackloss for those in 
blink, off-screen, or both.
}
\examples{
\dontrun{
library(VWPre)
# Mark trackloss...
df <- mark_trackloss(data = dat, Type = "Both", ScreenSize = c(1920, 1080))
}
}
