% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangerImpute.R
\name{rangerImpute}
\alias{rangerImpute}
\title{Random Forest Imputation}
\usage{
rangerImpute(
  formula,
  data,
  imp_var = TRUE,
  imp_suffix = "imp",
  ...,
  verbose = FALSE,
  median = FALSE
)
}
\arguments{
\item{formula}{model formula for the imputation}

\item{data}{A \code{data.frame} containing the data}

\item{imp_var}{\code{TRUE}/\code{FALSE} if a \code{TRUE}/\code{FALSE} variables for each imputed
variable should be created show the imputation status}

\item{imp_suffix}{suffix used for TF imputation variables}

\item{...}{Arguments passed to \code{\link[ranger:ranger]{ranger::ranger()}}}

\item{verbose}{Show the number of observations used for training
and evaluating the RF-Model. This parameter is also passed down to
\code{\link[ranger:ranger]{ranger::ranger()}} to show computation status.}

\item{median}{Use the median (rather than the arithmetic mean) to average
the values of individual trees for a more robust estimate.}
}
\value{
the imputed data set.
}
\description{
Impute missing values based on a random forest model using \code{\link[ranger:ranger]{ranger::ranger()}}
}
\examples{
data(sleep)
rangerImpute(Dream+NonD~BodyWgt+BrainWgt,data=sleep)
}
\seealso{
Other imputation methods: 
\code{\link{hotdeck}()},
\code{\link{impPCA}()},
\code{\link{irmi}()},
\code{\link{kNN}()},
\code{\link{matchImpute}()},
\code{\link{medianSamp}()},
\code{\link{regressionImp}()},
\code{\link{sampleCat}()}
}
\concept{imputation methods}
