% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{QMEDfseSS}
\alias{QMEDfseSS}
\title{QMED factorial standard error for gauged sites}
\usage{
QMEDfseSS(x)
}
\arguments{
\item{x}{a numeric vector. The sample of interest}
}
\value{
The factorial standard error for the median of a sample.
}
\description{
Estimates the median annual maximum flow (QMED) factorial standard error (FSE) by bootstrapping the sample
}
\details{
The bootstrapping procedure resamples from the sample N*500 times with replacement. After splitting into 500 samples of size N, the median is calculated for each. Then the exponent of the standard deviation of the log transformed residuals is taken as the FSE. i.e. exp(sd(log(x)-mean(log(x)))), where x is the bootstrapped medians.
}
\examples{
# Extract an AMAX sample and estimate the QMED factorial standard error
am_203018 <- GetAM(203018)
QMEDfseSS(am_203018$Flow)

}
\author{
Anthony Hammond
}
