test_that("bi-matrices work", {
  testthat::expect_is(m2_translation(c(1, 1)), "matrix")
  testthat::expect_type(m2_translation(c(1, 1)), "double")
  testthat::expect_equal(dim(m2_translation(c(1, 1))), c(3, 3))
  testthat::expect_error(m2_translation(NA))
  testthat::expect_error(m2_translation(NULL))
  testthat::expect_error(m2_translation("1"))
  testthat::expect_error(m2_translation(1))
  testthat::expect_error(m2_translation(c(1, 2, 3)))

  testthat::expect_is(m2_euclidean(c(2, 2), c(1, 1)), "matrix")
  testthat::expect_type(m2_euclidean(c(2, 2), c(1, 1)), "double")
  testthat::expect_equal(dim(m2_euclidean(c(2, 2), c(1, 1))), c(3, 3))
  testthat::expect_error(m2_euclidean(NA))
  testthat::expect_error(m2_euclidean(NULL))
  testthat::expect_error(m2_euclidean("1"))
  testthat::expect_error(m2_euclidean(1))
  testthat::expect_error(m2_euclidean(c(1, 2), c(1, 2, 3)))


  testthat::expect_is(m2_affine(c(2, 2), c(1, 1, 1, 1)), "matrix")
  testthat::expect_type(m2_affine(c(2, 2), c(1, 1, 1, 1)), "double")
  testthat::expect_equal(dim(m2_affine(c(2, 2), c(1, 1, 1, 1))), c(3, 3))
  testthat::expect_error(m2_affine(NA))
  testthat::expect_error(m2_affine(NULL))
  testthat::expect_error(m2_affine("1"))
  testthat::expect_error(m2_affine(1))
  testthat::expect_error(m2_affine(c(1, 2), c(1, 2, 3)))

  testthat::expect_is(m2_projective(c(2, 2), c(1, 1, 1, 1, 1, 1)), "matrix")
  testthat::expect_type(m2_projective(c(2, 2), c(1, 1, 1, 1, 1, 1)), "double")
  testthat::expect_equal(dim(m2_projective(c(2, 2), c(1, 1, 1, 1, 1, 1))), c(3, 3))
  testthat::expect_error(m2_projective(NA))
  testthat::expect_error(m2_projective(NULL))
  testthat::expect_error(m2_projective("1"))
  testthat::expect_error(m2_projective(1))
  testthat::expect_error(m2_projective(c(1, 2), c(1, 2, 3)))
})
