% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{NodeDepth}
\alias{NodeDepth}
\title{Distance of each node from tree exterior}
\usage{
NodeDepth(x, shortest = FALSE, includeTips = TRUE)
}
\arguments{
\item{x}{A tree of class \code{phylo}, its \verb{$edge} property, or a list thereof.}

\item{shortest}{Logical specifying whether to calculate the length of the
shortest away-from-root path to a leaf.  If \code{FALSE}, the length of the
longest such route will be returned.}

\item{includeTips}{Logical specifying whether to include leaves
(each of depth zero) in return value.}
}
\value{
\code{NodeDepth()} returns an integer vector specifying the depth of
each external and internal node in \code{x}.
}
\description{
\code{NodeDepth()} evaluates how "deep" each node is within a tree.
}
\details{
For a rooted tree, the depth of a node is the minimum (if \code{shortest = TRUE})
or maximum  (\code{shortest = FALSE}) number of edges that must be traversed,
moving away from the root, to reach a leaf.

Unrooted trees are treated as if a root node occurs in the "middle" of the
tree, meaning the position that will minimise the maximum node depth.
}
\examples{
tree <- CollapseNode(BalancedTree(10), c(12:13, 19))
plot(tree)
nodelabels(NodeDepth(tree, includeTips = FALSE))


}
\seealso{
\code{\link[ape:node.depth]{ape::node.depth}} returns the number of tips descended from a
node.

Other tree navigation: 
\code{\link{AncestorEdge}()},
\code{\link{CladeSizes}()},
\code{\link{DescendantEdges}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{ListAncestors}()},
\code{\link{MRCA}()},
\code{\link{MatchEdges}()},
\code{\link{NDescendants}()},
\code{\link{NodeNumbers}()},
\code{\link{NodeOrder}()},
\code{\link{RootNode}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree navigation}
