% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFrequencies.R
\name{plotFreq}
\alias{plotFreq}
\title{Plot Raw Frequencies}
\usage{
plotFreq(x, freq = TRUE, select = "all", boxplot = TRUE, eqnfile, ...)
}
\arguments{
\item{x}{either a fitted hierarchical MPT model (see \code{\link{traitMPT}},
\code{\link{betaMPT}}); or a matrix/data frame of response frequencies (can
be provided as a path to a .csv-file with individual frequencies).}

\item{freq}{whether to plot absolute frequencies or relative frequencies
(which sum up to one within each tree; only if \code{x} is a hierarchical
model or if \code{eqnfile} is provided)}

\item{select}{a numeric vector with participant indices to select which raw
frequencies to plot (default: \code{"all"})}

\item{boxplot}{if \code{FALSE}, lines and points are drawn instead of
boxplots}

\item{eqnfile}{optional: EQN description of an MPT model, that is, either the
path to an EQN file or as a character string (only used if \code{x} refers
to a matrix/data frame or .csv-file)}

\item{...}{further arguments passed to \code{boxplot} and \code{plot}}
}
\description{
Plot observed individual and mean frequencies.
}
\examples{
# get frequency data and EQN file
freq <- subset(arnold2013, group == "encoding", select = -(1:4))
eqn <- system.file("MPTmodels/2htsm.eqn", package = "TreeBUGS")
plotFreq(freq, eqnfile = eqn)
plotFreq(freq, freq = FALSE, eqnfile = eqn)
}
