% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random-tidy-normal.R
\name{tidy_normal}
\alias{tidy_normal}
\title{Tidy Randomly Generated Gaussian Distribution Tibble}
\usage{
tidy_normal(.n = 50, .mean = 0, .sd = 1, .num_sims = 1, .return_tibble = TRUE)
}
\arguments{
\item{.n}{The number of randomly generated points you want.}

\item{.mean}{The mean of the randomly generated data.}

\item{.sd}{The standard deviation of the randomly generated data.}

\item{.num_sims}{The number of randomly generated simulations you want.}

\item{.return_tibble}{A logical value indicating whether to return the result
as a tibble. Default is TRUE.}
}
\value{
A tibble of randomly generated data.
}
\description{
This function will generate \code{n} random points from a Gaussian
distribution with a user provided, \code{.mean}, \code{.sd} - standard deviation and number of
random simulations to be produced. The function returns a tibble with the
simulation number column the x column which corresponds to the n randomly
generated points, the \code{dnorm}, \code{pnorm} and \code{qnorm} data points as well.

The data is returned un-grouped.

The columns that are output are:
\itemize{
\item \code{sim_number} The current simulation number.
\item \code{x} The current value of \code{n} for the current simulation.
\item \code{y} The randomly generated data point.
\item \code{dx} The \code{x} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{dy} The \code{y} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{p} The values from the resulting p_ function of the distribution family.
\item \code{q} The values from the resulting q_ function of the distribution family.
}
}
\details{
This function uses the underlying \code{stats::rnorm()}, \code{stats::pnorm()},
and \code{stats::qnorm()} functions to generate data from the given parameters. For
more information please see \code{\link[stats:Normal]{stats::rnorm()}}
}
\examples{
tidy_normal()

}
\seealso{
Other Continuous Distribution: 
\code{\link{tidy_beta}()},
\code{\link{tidy_burr}()},
\code{\link{tidy_cauchy}()},
\code{\link{tidy_chisquare}()},
\code{\link{tidy_exponential}()},
\code{\link{tidy_f}()},
\code{\link{tidy_gamma}()},
\code{\link{tidy_generalized_beta}()},
\code{\link{tidy_generalized_pareto}()},
\code{\link{tidy_inverse_burr}()},
\code{\link{tidy_inverse_exponential}()},
\code{\link{tidy_inverse_gamma}()},
\code{\link{tidy_inverse_normal}()},
\code{\link{tidy_inverse_pareto}()},
\code{\link{tidy_inverse_weibull}()},
\code{\link{tidy_logistic}()},
\code{\link{tidy_lognormal}()},
\code{\link{tidy_paralogistic}()},
\code{\link{tidy_pareto}()},
\code{\link{tidy_pareto1}()},
\code{\link{tidy_t}()},
\code{\link{tidy_triangular}()},
\code{\link{tidy_uniform}()},
\code{\link{tidy_weibull}()},
\code{\link{tidy_zero_truncated_geometric}()}

Other Gaussian: 
\code{\link{tidy_inverse_normal}()},
\code{\link{util_normal_param_estimate}()},
\code{\link{util_normal_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Continuous Distribution}
\concept{Gaussian}
