% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp.R
\name{cp}
\alias{cp}
\title{Copy Files}
\usage{
cp(from, to, move = FALSE, ignore = FALSE, overwrite = TRUE,
  quiet = TRUE)
}
\arguments{
\item{from}{source filenames, e.g. \code{*.csv}.}

\item{to}{destination filenames, or directory.}

\item{move}{whether to move instead of copy.}

\item{ignore}{whether to suppress error if source file does not exist.}

\item{overwrite}{whether to overwrite if destination file exists.}

\item{quiet}{whether to suppress messages.}
}
\value{
\code{TRUE} for success, \code{FALSE} for failure, invisibly.
}
\description{
Copy or move files, overwriting existing files if necessary, and returning
the result invisibly.
}
\note{
To prevent accidental loss of files, two safeguards are enforced when
\code{move = TRUE}:
\enumerate{
\item When moving files, the \code{to} argument must either have a filename
      extension or be an existing directory.
\item When moving many files to one destination, the \code{to} argument must
      be an existing directory.
}
If these conditions do not hold, no files are changed and an error is
returned.
}
\examples{
\dontrun{
write(pi, "A.txt")
cp("A.txt", "B.txt")
cp("A.txt", "B.txt", move=TRUE)

# Copy directory tree
cp(system.file(package="datasets"), ".")
mkdir("everything")
cp("datasets/*", "everything")
}

}
\seealso{
\code{\link{file.copy}} and \code{\link{unlink}} are the underlying functions
used to copy and (if \code{move = TRUE}) delete files.

\code{\link{file.rename}} is the base function to rename files.

\code{\link{TAF-package}} gives an overview of the package.
}
