% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acf2msd.R
\name{acf2msd}
\alias{acf2msd}
\title{Convert autocorrelation of stationary increments to mean squared displacement of posititions.}
\usage{
acf2msd(acf)
}
\arguments{
\item{acf}{Length-\code{N} autocorrelation vector of a stationary increment sequence.}
}
\value{
Length-\code{N} MSD vector of the corresponding positions.
}
\description{
Converts the autocorrelation of a stationary increment sequence \verb{dx = (x_1 - x_0, ..., x_N - x_(N-1))} to the mean squared displacement (MSD) of the corresponding positions, i.e., \code{MSD_i = E[(x_i - x_0)^2]}.
}
\examples{
acf2msd(acf = exp(-(0:10)))
}
