% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpowerCurve.R
\name{SpowerCurve}
\alias{SpowerCurve}
\title{Draw power curve from simulation functions}
\usage{
SpowerCurve(
  ...,
  interval = NULL,
  power = NA,
  sig.level = 0.05,
  replications = 2500,
  integer,
  plotCI = TRUE,
  plotly = TRUE,
  parallel = FALSE,
  cl = NULL,
  ncores = parallelly::availableCores(omit = 1L),
  predCI = 0.95,
  predCI.tol = 0.01,
  verbose = TRUE,
  check.interval = FALSE,
  maxiter = 50,
  wait.time = NULL,
  select = NULL,
  control = list()
)
}
\arguments{
\item{...}{first expression input must be identical to \code{...} in
\code{\link{Spower}}, while the remaining named inputs must match the arguments
to this expression to indicate which variables should be modified in the
resulting power curves. Providing \code{NA} values is also supported to
solve the missing component

Note that only the first three named arguments will be plotted using
the x-y, colour, and facet wrap aesthetics, respectively. However,
if necessary the data can be extracted for further visualizations via
\code{\link[ggplot2]{ggplot_build}} to provide more customized control}

\item{interval}{search interval to use when \code{\link[SimDesign]{SimSolve}} is required.
Can be a vector of length two to apply the same interval across
the \code{varying} information or a \code{matrix} with two columns
to apply intervals on a per-row basis}

\item{power}{power level to use. If set to \code{NA} then the empirical power
will be estimated given the fixed \code{...} input; otherwise,
can be specified as a vector to solve the missing elements in
\code{...}}

\item{sig.level}{see \code{\link{Spower}}}

\item{replications}{see \code{\link{Spower}}, though set to 2500 instead of
10000}

\item{integer}{see \code{\link{Spower}}}

\item{plotCI}{logical; include confidence/prediction intervals in plots?}

\item{plotly}{logical; draw the graphic into the interactive \code{plotly}
interface? If \code{FALSE} the ggplot2 object will be returned instead}

\item{parallel}{see \code{\link{Spower}}}

\item{cl}{see \code{\link{Spower}}}

\item{ncores}{see \code{\link{Spower}}}

\item{predCI}{see \code{\link{Spower}}}

\item{predCI.tol}{see \code{\link{Spower}}}

\item{verbose}{see \code{\link{Spower}}}

\item{check.interval}{see \code{\link{Spower}}, though is set to \code{FALSE}
by default instead}

\item{maxiter}{see \code{\link{Spower}}, though set to 50 instead of 150}

\item{wait.time}{see \code{\link{Spower}}}

\item{select}{which arguments to select from simulation experiment.
See \code{\link{Spower}} for details}

\item{control}{see \code{\link{Spower}}}
}
\value{
a ggplot2 object automatically rendered with
\code{plotly} for interactivity
}
\description{
Draws power curves that either a) estimate the power given a
set of varying conditions or b) solves a set of root conditions
given fixed values of power. Confidence/prediction intervals are
included in the output to reflect the estimate uncertainties, though note
that fewer replications/iterations are used compared to
\code{\link{Spower}} as the goal is visualization of competing
variable inputs rather than precision of a given input.
}
\examples{
\donttest{

# estimate power given varying sample sizes
gg <- p_t.test(d=0.2) |> SpowerCurve(n=c(30, 90, 270, 550))

# Output is a ggplot2 (rendered with plotly by default); hence, can be modified
library(ggplot2)
gg + geom_text(aes(label=power), size=5, colour='red', nudge_y=.05) +
  ylab(expression(1-beta)) + theme_grey()

# Increase precision by using 10000 replications. Parallel computations
#   generally recommended in this case to save time
p_t.test(d=0.2) |> SpowerCurve(n=c(30, 90, 270, 550), replications=10000)

# estimate sample sizes given varying power
p_t.test(n=NA, d=0.2) |>
  SpowerCurve(power=c(.2, .4, .6, .8), interval=c(10, 1000))

# get information from last printed graphic instead of saving
gg <- last_plot()
gg + coord_flip() # flip coordinates to put power on y-axis

# estimate power varying d
p_t.test(n=50) |> SpowerCurve(d=seq(.1, 1, by=.2))

# estimate d varying power
p_t.test(n=50, d=NA) |>
  SpowerCurve(power=c(.2, .4, .6, .8), interval=c(.01, 1))


#####

# vary two inputs instead of one (second input uses colour aesthetic)
p_t.test() |> SpowerCurve(n=c(30, 90, 270, 550),
                         d=c(.2, .5, .8))

# extract data for alternative presentations
build <- ggplot_build(last_plot())
build

df <- build$plot$data
head(df)
ggplot(df, aes(n, power, linetype=d)) + geom_line()

# vary three arguments (third uses facet_wrap ... any more than that and
#   you're on your own!)
p_t.test() |> SpowerCurve(n=c(30, 90, 270, 550),
                         d=c(.2, .5, .8),
                         var.equal=c(FALSE, TRUE))

}

}
\seealso{
\code{\link{Spower}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
