% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_shapiro.test.R
\name{p_shapiro.test}
\alias{p_shapiro.test}
\title{p-value from Shapiro-Wilk Normality Test simulation}
\usage{
p_shapiro.test(dist)
}
\arguments{
\item{dist}{expression used to generate the required sample data}
}
\value{
a single p-value
}
\description{
Generates univariate distributional data and returns a p-value to assess the null
that the population follows a Gaussian distribution shape. Uses
\code{\link{shapiro.test}}.
}
\examples{

# 50 observations drawn from normal distribution (null is true)
p_shapiro.test(rnorm(50))

# 50 observations from slightly skewed chi-squared distribution (power)
p_shapiro.test(rchisq(50, df=100))

\donttest{
    # empirical Type I error rate estimate
    p_shapiro.test(rnorm(50)) |> Spower()

    # power
    p_shapiro.test(rchisq(50, df=100)) |> Spower()
}

}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
