% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimension_reduction.R
\name{Jaccard}
\alias{Jaccard}
\title{Calculate the Jaccard index between two matrices}
\usage{
Jaccard(x, y)
}
\arguments{
\item{x}{The first matrix}

\item{y}{The second matrix}
}
\value{
Returns a matrix
}
\description{
Finds the Jaccard similarity between rows of the two matrices. Note that
the matrices must be binary, and any rows with zero total counts will result
in an NaN entry that could cause problems in downstream analyses.
}
\details{
This will calculate the raw Jaccard index, without normalizing for the
expected similarity between cells due to differences in sequencing depth.
}
\examples{
x <- matrix(data = sample(c(0, 1), size = 25, replace = TRUE), ncol = 5)
Jaccard(x = x, y = x)
}
\concept{dimension_reduction}
