% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{BigwigTrack}
\alias{BigwigTrack}
\title{Plot data from BigWig files}
\usage{
BigwigTrack(
  region,
  bigwig,
  smooth = 200,
  extend.upstream = 0,
  extend.downstream = 0,
  type = "coverage",
  y_label = "bigWig",
  bigwig.scale = "common",
  ymax = NULL,
  max.downsample = 3000,
  downsample.rate = 0.1
)
}
\arguments{
\item{region}{GRanges object specifying region to plot}

\item{bigwig}{List of bigwig file paths. List should be named, and the name
of each element in the list of files will be displayed alongside the track
in the final plot.}

\item{smooth}{Number of bases to smooth data over (rolling mean). If NULL,
do not apply smoothing.}

\item{extend.upstream}{Number of bases to extend the region upstream.}

\item{extend.downstream}{Number of bases to extend the region downstream.}

\item{type}{Plot type. Can be one of "line", "heatmap", or "coverage"}

\item{y_label}{Y-axis label}

\item{bigwig.scale}{Scaling to apply to data from different bigwig files.
Can be:
\itemize{
\item{common: plot each bigwig on a common scale (default)}
\item{separate: plot each bigwig on a separate scale ranging from zero to the
maximum value for that bigwig file within the plotted region}
}}

\item{ymax}{Maximum value for Y axis. Can be one of:
\itemize{
\item{NULL: set to the highest value among all the tracks (default)}
\item{qXX: clip the maximum value to the XX quantile (for example, q95 will
set the maximum value to 95\% of the maximum value in the data). This can help
remove the effect of extreme values that may otherwise distort the scale.}
\item{numeric: manually define a Y-axis limit}
}}

\item{max.downsample}{Minimum number of positions kept when downsampling.
Downsampling rate is adaptive to the window size, but this parameter will set
the minimum possible number of positions to include so that plots do not
become too sparse when the window size is small.}

\item{downsample.rate}{Fraction of positions to retain when downsampling.
Retaining more positions can give a higher-resolution plot but can make the
number of points large, resulting in larger file sizes when saving the plot
and a longer period of time needed to draw the plot.}
}
\value{
Returns a ggplot object
}
\description{
Create coverage tracks, heatmaps, or line plots from bigwig files.
}
\details{
Note that this function does not work on windows.
}
\concept{visualization}
