% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigexp.R
\name{bigexp_train}
\alias{bigexp_train}
\title{Build a spec and prepare training data in one call}
\usage{
bigexp_train(formula, data, ...)
}
\arguments{
\item{formula}{Main-effects formula such as y ~ X1 + X2 + G or y ~ .
Only main effects should appear on the right hand side.}

\item{data}{Training data frame used to lock types and levels.}

\item{...}{Additional arguments forwarded to bigexp_terms(), such as
factorial_order, discrete_threshold, polynomial_order, include_pc_2way,
include_pc_3way, and intercept.}
}
\value{
An object of class "bigexp_train" which is a list with components:
\itemize{
\item spec: the "bigexp_spec" object returned by bigexp_terms()
\item formula: the expanded formula spec$formula
\item data: the prepared training data ready for modeling
}
}
\description{
bigexp_train() is a convenience wrapper around bigexp_terms() and
bigexp_prepare(). It:
\itemize{
\item Builds a deterministic expansion spec from the training data
\item Immediately prepares that same data to match the locked types and levels
}
}
\details{
This is handy when you want a single object that contains both the spec
and the expanded training data ready to pass into a modeling function.
For more control, you can call bigexp_terms() and bigexp_prepare()
explicitly instead.
}
\examples{
set.seed(1)
df5 <- data.frame(
  y  = rnorm(20),
  X1 = rnorm(20),
  X2 = rnorm(20)
)

tr <- bigexp_train(
  y ~ X1 + X2,
  data             = df5,
  factorial_order  = 2,
  polynomial_order = 3
)

str(tr$data)
tr$formula

}
