% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_netgeom.R
\name{create_netgeom}
\alias{create_netgeom}
\title{Create netgeom column in SSN object}
\usage{
create_netgeom(sf_data, type = NULL, overwrite = FALSE)
}
\arguments{
\item{sf_data}{An \code{sf} object with LINESTING or POINT geometry
created using \code{link{lsn_to_ssn}} (see Details).}

\item{type}{Character string defining geometry type of
\code{sf_data}. Default = \code{NULL}.}

\item{overwrite}{Logical indicating whether existing data should be
overwritten if present. Default = \code{FALSE}.}
}
\value{
An \code{sf} object containing the original data from
\code{sf_data} and an additional column named netgeom.
}
\description{
Create netgeom column for edges, observed sites,
and/or prediction sites in a Landscape Network (LSN).
}
\details{
Most users will not need to run \code{create_netgeom}
themselves because it is called internally when \code{lsn_to_ssn}
is run or an \code{SSN} is imported using
\code{link[SSN2]{ssn_import}} found in the \code{SSN2}
package. For users who do wish to run \code{create_netgeom}, the
\code{sf_data} object must represent edges, observed sites, or
prediction sites in a \code{SSN} object created using
\code{link{lsn_to_ssn}}.

The netgeom column contains information in character format used
to describe the topology of the LSN. The format and content of
the netgeom column differs depending on whether \code{sf_data}
contains LINESTRING (edges) or POINT (observed or prediction
sites) geometry. For edges, the netgeom format is:
\itemize{
\item{\code{'ENETWORK (netID, rid, upDist)'}}
}

For observed or prediction sites, the netgeom format is:
\itemize{
\item{\code{'SNETWORK (netID, rid, upDist, ratio, pid, locID)'}}
}

The rid, ratio, upDist, netID, pid, and locID columns must be
present in \code{sf_data} before netgeom is added.

If \code{overwrite = TRUE} and a column named netgeom is present in
\code{sf_data}, the data will be overwritten. Default = FALSE.
}
\examples{
## Create local temporary copy of MiddleFork04.ssn found in
## the SSN2 package. Only necessary for this example.
copy_lsn_to_temp()

# Import the SSN object with prediction points, pred1km
mf04<- ssn_import(
   paste0(tempdir(), "/MiddleFork04.ssn"),
   predpts = c("pred1km"),
   overwrite = TRUE
)

# Recalculate the netgeom column for the observed sites
sf_obs <- create_netgeom(
    mf04$obs,
    type = "POINT",
    overwrite = TRUE
)

# Recalculate the netgeom column for the edges
sf_edges <- create_netgeom(
    mf04$edges,
    type = "LINESTRING",
    overwrite = TRUE
)
}
