% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.frame.R
\name{model.frame.SSN2}
\alias{model.frame.SSN2}
\alias{model.frame.ssn_lm}
\alias{model.frame.ssn_glm}
\title{Extract the model frame from a fitted model object}
\usage{
\method{model.frame}{ssn_lm}(formula, ...)

\method{model.frame}{ssn_glm}(formula, ...)
}
\arguments{
\item{formula}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A model frame that contains the variables used by the formula
for the fitted model object.
}
\description{
Extract the model frame from a fitted model object.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
model.frame(ssn_mod)
}
\seealso{
\code{\link[stats:model.frame]{stats::model.frame()}}
}
