% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{mbound_LiuLiu}
\alias{mbound_LiuLiu}
\title{bound for number of columns for LiuLiu OSOAs}
\usage{
mbound_LiuLiu(moa, t)
}
\arguments{
\item{moa}{number of oa columns}

\item{t}{strength used in the construction in function \code{OSOAs_LiuLiu}
(it is assumed that the \code{oa} used has at least that strength)}
}
\value{
the maximum number of columns that can be obtained by the command
\code{OSOAs_LiuLiu(oa, t=t)} where oa has at least strength \code{t} and
consists of \code{moa} columns
}
\description{
bound for number of columns for LiuLiu OSOAs
}
\examples{
## moa is the number of columns of an oa
moa <- rep(seq(4,40),3)
## t is the strength used in the construction
##      the oa must have at least this strength
t <- rep(2:4, each=37)
## numbers of columns for the combination
mbounds <- mapply(mbound_LiuLiu, moa, t)
## depending on the number of levels
## the number of runs can be excessive
## for larger values of moa with larger t!
## t=3 and t=4 have the same number of columns, except for moa=4*j+3
plot(moa, mbounds, pch=t, col=t)
}
\references{
#' For full detail, see \code{\link{SOAs-package}}.

Liu and Liu 2015
}
\author{
Ulrike Groemping
}
