% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyntaxa_api_functions.R
\name{get_dyntaxa_dwca}
\alias{get_dyntaxa_dwca}
\title{Download and read Darwin Core Archive files from Dyntaxa}
\usage{
get_dyntaxa_dwca(
  subscription_key = Sys.getenv("DYNTAXA_KEY"),
  file_to_read = "Taxon.csv",
  force = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{subscription_key}{A Dyntaxa API subscription key. By default, the key
is read from the environment variable \code{DYNTAXA_KEY}.

You can provide the key in three ways:
\itemize{
\item \strong{Directly as a parameter}:
\code{get_dyntaxa_dwca(subscription_key = "your_key_here")}.
\item \strong{Temporarily for the session}:
\code{Sys.setenv(DYNTAXA_KEY = "your_key_here")}.
After this, you do not need to pass \code{subscription_key} to the function.
\item \strong{Permanently across sessions} by adding it to your \code{~/.Renviron} file.
Use \code{usethis::edit_r_environ()} to open the file, then add:
\code{DYNTAXA_KEY=your_key_here}.
After this, you do not need to pass \code{subscription_key} to the function.
}}

\item{file_to_read}{A string specifying the name of the CSV file to read from the extracted archive.
Allowed options are: \code{"Reference.csv"}, \code{"SpeciesDistribution.csv"}, \code{"Taxon.csv"}, or \code{"VernacularName.csv"}. Defaults to \code{"Taxon.csv"}.}

\item{force}{A logical value indicating whether to force a fresh download of the archive,
even if a cached copy is available. Defaults to \code{FALSE}.}

\item{verbose}{A logical value indicating whether to show download progress. Defaults to \code{TRUE}.}
}
\value{
A tibble containing the data from the specified CSV file.
}
\description{
This function downloads a complete Darwin Core Archive (DwCA) of Dyntaxa from the SLU Artdatabanken API,
extracts the archive, and reads the specified CSV file into R.
}
\details{
By default, the archive is downloaded and cached across R sessions. On subsequent calls,
the function reuses the cached copy of the extracted files to avoid repeated downloads.
Use the \code{force} parameter to re-download the archive if needed. The cache is cleared
automatically after 24 hours, but you can also manually clear it using
\code{\link{clean_shark4r_cache}}.

A valid Dyntaxa API subscription key is required.
You can request a free key for the "Taxonomy" service from the ArtDatabanken API portal:
\url{https://api-portal.artdatabanken.se/}

\strong{Note}: Please review the \href{https://www.slu.se/artdatabanken/rapportering-och-fynd/oppna-data-och-apier/}{API conditions}
and \href{https://api-portal.artdatabanken.se/}{register for access} before using the API. Data collected through the API
is stored at SLU Artdatabanken. Please also note that the authors of \code{SHARK4R} are not affiliated with SLU Artdatabanken.
}
\examples{
\dontrun{
# Provide your Dyntaxa API subscription key
subscription_key <- "your_subscription_key"

# Download and read the Taxon.csv file
taxon_data <- get_dyntaxa_dwca(subscription_key, file_to_read = "Taxon.csv")
}

}
\seealso{
\code{\link[=clean_shark4r_cache]{clean_shark4r_cache()}} to manually clear cached files.
}
