% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{convert_ddmm_to_dd}
\alias{convert_ddmm_to_dd}
\title{Convert coordinates from DDMM format to decimal degrees}
\usage{
convert_ddmm_to_dd(coord)
}
\arguments{
\item{coord}{A numeric or character vector of coordinates in DDMM format.}
}
\value{
A numeric vector of decimal degrees corresponding to the input coordinates.
Names from the input vector are removed.
}
\description{
This function converts geographic coordinates provided in the DDMM
format (degrees and minutes) to decimal degrees. It can handle:
\itemize{
\item DDMM (e.g., 5733 to 57°33' to 57.55°)
\item DDMMss or DDMMss… (extra digits after minutes are interpreted
as fractional minutes, e.g., 573345 to 57°33.45' to 57.5575°)
}
}
\details{
Non-numeric characters are removed before conversion. Coordinates
shorter than 4 digits are returned as \code{NA}.
}
\examples{
# Basic DDMM input
convert_ddmm_to_dd(c(5733, 6045))
# Input with fractional minutes
convert_ddmm_to_dd(c("573345", "604523"))
# Input with non-numeric characters
convert_ddmm_to_dd(c("57°33'", "60°45'23\""))

}
