% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{sample_sizes}
\alias{sample_sizes}
\alias{se_d}
\alias{n_d}
\alias{se_r}
\alias{n_r}
\alias{se_z}
\alias{n_z}
\title{Sample sizes to standard errors calculations}
\usage{
se_d(d, n)

n_d(d, se)

se_r(r, n)

n_r(r, se)

se_z(n)

n_z(se)
}
\arguments{
\item{d}{Cohen's d}

\item{n}{sample size of the corresponding effect size}

\item{se}{standard error of the corresponding effect size}

\item{r}{correlation coefficient}
}
\description{
Functions for transforming between standard
errors and sample sizes (assuming equal sample sizes per group).
}
\details{
Calculations for Cohen's d, Fisher's z, and log(OR) are
based on \insertCite{borenstein2011introduction}{RoBMA}. Calculations
for correlation coefficient were modified to make the standard error
corresponding to the computed on Fisher's z scale under the same sample
size (in order to make all other transformations consistent). In case that
a direct transformation is not available, the transformations
are chained to provide the effect size of interest.

Note that sample size and standard error calculation for log(OR)
is not available. The standard error is highly dependent on the
odds within the groups and sample sizes for individual events are
required. Theoretically, the sample size could be obtained by
transforming the effect size and standard error to a different measure
and obtaining the sample size using corresponding function, however,
it leads to a very poor approximation and it is not recommended.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=effect_sizes]{effect_sizes()}}, \code{\link[=standard_errors]{standard_errors()}}
}
