% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_load_model.R
\name{load_model}
\alias{load_model}
\title{Load model}
\usage{
load_model(name, dir = tempdir())
}
\arguments{
\item{name}{The name of the model to load.}

\item{dir}{The directory in which the model lives.}
}
\value{
An \code{RSTr} model object.
}
\description{
\code{load_model()} imports an \code{RSTr} object with name \code{name} in directory \code{dir}.
}
\examples{
data_min <- lapply(miheart, \(x) x[1:2, 1:3, 1:3])
adj_min <- list(2, 1)
mod_mst <- mstcar("test", data_min, adj_min, tempdir(), show_plots = FALSE, verbose = FALSE)
mod_mst <- load_model(name = "test", dir = tempdir())
\dontshow{
unlink(paste0(tempdir(), "\\\\test"), recursive = TRUE)
}
}
