#' @title Gene expression dataset for RQdeltaCT package - variant with three groups.
#' @description Dataset that contain table with gene expression data obtained for 19 genes and 104 samples using qPCR experiments with TaqMan assays.
#' Samples are divided into three groups: Disease AAA (40 samples), Disease VV (40 samples), and Control (24 samples). This dataset is a part of data used in articles:
#' Zalewski, D.; Chmiel, P.; Kołodziej, P.; Borowski, G.; Feldo, M.; Kocki, J.; Bogucka-Kocka, A. Dysregulations of Key Regulators of Angiogenesis and Inflammation in Abdominal Aortic Aneurysm. Int. J. Mol. Sci. 2023, 24, 12087. https://doi.org/10.3390/ijms241512087 and Zalewski, D.; Chmiel, P.; Kołodziej, P.; Kocki, M.; Feldo, M.; Kocki, J.; Bogucka-Kocka, A. Key Regulators of Angiogenesis and Inflammation Are Dysregulated in Patients with Varicose Veins. Int. J. Mol. Sci. 2024, 25, 6785. https://doi.org/10.3390/ijms25126785
#' @format A data frame with 2048 rows and 5 variables:
#' \describe{
#'   \item{\code{Sample}}{character COLUMN_DESCRIPTION}
#'   \item{\code{Gene}}{character COLUMN_DESCRIPTION}
#'   \item{\code{Ct}}{character COLUMN_DESCRIPTION}
#'   \item{\code{Group}}{character COLUMN_DESCRIPTION}
#'   \item{\code{FLAG}}{character COLUMN_DESCRIPTION}
#'}
#' @source Dataset is attached to the `RQdeltaCT` package and can be loaded using `data(data.Ct.3groups)` command.
"data.Ct.3groups"
