% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_default_gompertz_parameters.R
\name{get_default_gompertz_parameters}
\alias{get_default_gompertz_parameters}
\title{Get default Gompertz parameters}
\usage{
get_default_gompertz_parameters(
  age,
  country = unique(life_tables$country),
  sex = c("both", "male", "female")
)
}
\arguments{
\item{age}{A numeric. The age of the individual.}

\item{country}{A character. The name of the country.}

\item{sex}{A character. The sex of the individual.}
}
\value{
A list containing:
\item{mode}{The mode of the Gompertz distribution}
\item{dispersion}{The dispersion parameter of the Gompertz distribution}
\item{current_age}{The current age parameter}
\item{max_age}{The maximum age parameter}
}
\description{
Calculates default Gompertz parameters for a given age, country and sex,
based on the package build-in HMD life tables.
}
\examples{
get_default_gompertz_parameters(
  age     = 65,
  country = "USA",
  sex     = "male"
)
}
\seealso{
\code{\link[=calc_gompertz_parameters]{calc_gompertz_parameters()}}
}
