% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{orthogonize_bspline}
\alias{orthogonize_bspline}
\title{Orthogonalized B-splines}
\usage{
orthogonize_bspline(
  knots,
  boundary_knots,
  degree,
  predictors = NULL,
  is_approx = FALSE
)
}
\arguments{
\item{knots}{Array. The knots that define the spline.}

\item{boundary_knots}{Array. The breakpoints that define the spline.}

\item{degree}{Integer. The degree of the piecewise polynomial.}

\item{predictors}{Array. The predictor variables with size p.}

\item{is_approx}{Boolean. The default is \code{FALSE}.}
}
\value{
A list containing:
\item{\code{bsplines}}{Matrix of orthogonalized B-splines with dimensions \eqn{(p, \text{length}(knots) + \text{degree} + 1)}}
\item{\code{z}}{Predictors used in generation}
}
\description{
Generate a set of orthogonalized B-splines using the Gram-Schmidt algorithm applied to the built-in function \code{splines::bs()}.
}
\examples{
# Example: Generate and plot the first 5 orthogonalized B-splines
p <- 30
total_knots <- 10
degree <- 3
boundaries <- c(0, 1)
x <- seq(from = 0, to = 1, length.out = total_knots)
knots <- x[2:(total_knots - 1)]
predictors <- runif(p, min = 0, max = 1)
bsplines <- orthogonize_bspline(knots, boundaries, degree, predictors)

# Plot the first 5 B-splines
index <- order(bsplines$z)
original_par <- par(no.readonly = TRUE)
par(mfrow = c(1, 5))
for (i in 1:5)
  plot(bsplines$z[index], bsplines$bsplines[index, i], main = i, type = "l")
par(original_par)
}
