% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/command.R
\name{pt2_command}
\alias{pt2_command}
\alias{pt2_command<-}
\title{Extract effect commands from a ProTracker module}
\usage{
pt2_command(x, ...)

pt2_command(x, silent = TRUE, ...) <- value
}
\arguments{
\item{x}{An object of class \code{pt2cell}, which can be extracted
from a pattern table with \code{\link[=pt2_cell]{pt2_cell()}}. A cell list (class \code{pt2celllist})
is also allowed. See \code{vignette("sel_assign")} for more details about
selecting cells and cell lists.}

\item{...}{Ignored}

\item{silent}{Don't warn about replacement values not being used or recycled.}

\item{value}{A replacement value. It should be an object that can be converted into
an effect command. It can be a \code{character} string as shown in the example below.}
}
\value{
Returns a \code{pt2command} object containing the raw command code.
In case of the assign operator (\verb{<-}) an update version of \code{x} is returned.
}
\description{
As explained in \code{vignette("s3class")}, the ProTracker pattern table
consists of cells, containing information about the note and instrument
to be played. This function can be used to retrieve or replace the
effect commands in a module.
}
\examples{
mod <- pt2_read_mod(pt2_demo())

## select a specific cell from the module
cell <- pt2_cell(mod$patterns[[1]], 0L, 0L)

## show the command used for this cell
pt2_command(cell)

## convert character strings into ProTracker commands
pt2_command(c("C30", "F06"))

## Set the command for all cells in the first pattern
## to `C20` (volume at 50\%):
pt2_command(mod$patterns[[1]][]) <- "C20"
}
