% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/U03-weights.R
\name{trim_weights_asymmetric}
\alias{trim_weights_asymmetric}
\title{Asymmetric Propensity Score Trimming (Sturmer Extension)}
\usage{
trim_weights_asymmetric(ps_result, data, treatment_var, alpha = NULL)
}
\arguments{
\item{ps_result}{A list returned by \code{estimate_ps()}.}

\item{data}{A data.frame containing the treatment variable.}

\item{treatment_var}{A character string specifying the name of the treatment
variable in \code{data}.}

\item{alpha}{Numeric percentile threshold in (0, 0.5). Default is NULL,
which uses recommended values: 0.05 for binary treatment, 0.033 for 3 groups,
1/(2*J) for J >= 4.}
}
\value{
A logical vector of length n, where TRUE indicates the observation
  should be kept and FALSE indicates it should be trimmed.
}
\description{
Performs asymmetric (percentile-based) trimming using within-group percentile
thresholds. Implements the Sturmer extension to multiple treatments as
described in Yoshida et al. (2019).
}
\details{
The asymmetric trimming rule retains observation i if:
\deqn{e_{ji} \geq F^{-1}_{e_{ji}|A_i=j}(\alpha|j) \text{ for all } j}

where \eqn{F^{-1}_{e_{ji}|A_i=j}(\alpha|j)} is the \eqn{\alpha}-percentile of
propensity scores \eqn{e_{ji}} among individuals who actually received
treatment j.
}
\references{
Yoshida, K., et al. (2019). Multinomial extension of propensity score trimming
methods: A simulation study. \emph{American Journal of Epidemiology}, 188(3),
609-616.
}
\keyword{internal}
