% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PMR_individual}
\alias{PMR_individual}
\title{PMR model with individual level data}
\usage{
PMR_individual(yin, zin, x1in, x2in, gammain, alphain, max_iterin, epsin)
}
\arguments{
\item{yin}{standardized exposure vector (e.g. gene expression in TWAS).}

\item{zin}{standardized complex trait vector.}

\item{x1in}{standardized cis-genotype matrix in eQTL data.}

\item{x2in}{standardized cis-genotype matrix in GWAS data.}

\item{gammain}{indicator variable for constrained PMR model, with 1 for the null 
model that there is no horizontal pleiotropy.}

\item{alphain}{indicator variable for constrained PMR model, with 1 for the null 
model that there is no causal effect.}

\item{max_iterin}{The maximum iteration.}

\item{epsin}{The convergence tolerance of the absolute value of the difference 
between the nth and (n+1)th log likelihood.}
}
\value{
a list of estimates of model parameters, including the causal effect 
\code{alpha}, the horizontal pleiotropy effect \code{gamma}, and the two 
corresponding p values
}
\description{
Fit the probabilistic MR model with individual level data while accounting for 
the correlated instruments and horizontal pleiotropy in TWAS framework.
}
\examples{
data(Exampleindividual)
attach(Exampleindividual)
fmH1 = PMR_individual(yin=x, zin=y, x1in=zx, x2in=zy,
                      gammain=0,alphain = 0,max_iterin =1000,epsin=1e-5)
alpha<-fmH1$alpha
gamma<-fmH1$gamma
fmH0gamma = PMR_individual(yin=x,zin= y, x1in=zx, x2in=zy,gammain=1, 
                           alphain = 0,max_iterin =1000,epsin=1e-5)
fmH0alpha = PMR_individual(yin=x, zin=y, x1in=zx, x2in=zy,gammain=0,
                           alphain = 1,max_iterin =1000, epsin=1e-5)
loglikH1=max(fmH1$loglik,na.rm=TRUE)
loglikH0gamma=max(fmH0gamma$loglik,na.rm=TRUE)
loglikH0alpha=max(fmH0alpha$loglik,na.rm=TRUE)
stat_alpha = 2 * (loglikH1 - loglikH0alpha)
pvalue_alpha = pchisq(stat_alpha,1,lower.tail=FALSE)
stat_gamma = 2 * (loglikH1 - loglikH0gamma)
pvalue_gamma = pchisq(stat_gamma,1,lower.tail=FALSE)

}
\author{
Zhongshang Yuan, Xiang Zhou.
}
