% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPSEA.R
\name{plotPSEA}
\alias{plotPSEA}
\title{Plot the results of protein set enrichment analysis (PSEA)}
\usage{
plotPSEA(x, y = NULL, sig.level = 0.05, number.rep = NULL)
}
\arguments{
\item{x}{A data frame returned by \code{\link{runPSEA}} function.}

\item{y}{Default value is NULL. If provided by a protein set enrichment results, the matching results
of x and y are plotted.}

\item{sig.level}{The significance level applied on adjusted p-value by permutation to filter pathways
for plotting. The default value is 0.05}

\item{number.rep}{Only plot PTM terms that occurred more than a specific number of times in UniProt. This number is set
by number.rep parameter. The default value is NULL.}
}
\value{
Plot
}
\description{
plotPSEA can be used to plot the results of protein set enrichment analysis (psea) for a set of proteins
obtained from an experiment.
}
\examples{
# We recommend at least nperm = 1000.
# The number of permutations was reduced to 10
# to accommodate CRAN policy on examples (run time <= 5 seconds).
psea_res <- runPSEA(protein = exmplData2, os.name = 'Rattus norvegicus (Rat)', nperm = 10)
plotPSEA(psea_res, sig.level = 0.05)

}
