% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMAddToListAttribute}
\alias{PCMAddToListAttribute}
\title{Add a value to a list-valued attribute of a member or members matching a pattern}
\usage{
PCMAddToListAttribute(
  name,
  value,
  object,
  member = "",
  enclos = "?",
  spec = TRUE,
  inplace = TRUE,
  ...
)
}
\arguments{
\item{name}{a character string denoting the attribute name.}

\item{value}{the value for the attribute.}

\item{object}{a PCM or a list object.}

\item{member}{a member expression. Member expressions are character strings
denoting named elements in a list object (see examples). Default: "".}

\item{enclos}{a character string containing the special symbol '?'. This
symbol is to be replaced by matching expressions. The result of this
substitution can be anything but, usually would be a valid R expression.
Default: "?".}

\item{spec}{a logical (TRUE by default) indicating if the attribute should
also be set in the corresponding member of the spec attribute (this is for
PCM objects only).}

\item{inplace}{logical (TRUE by default) indicating if the attribute should
be set to the object in the current environment, or a modified object should
be returned.}

\item{...}{additional arguments passed to \code{\link{MatchListMembers}}.}
}
\value{
if \code{inplace} is \code{TRUE} no value is returned. Otherwise, a
modified version of \code{object} is returned.
}
\description{
Add a value to a list-valued attribute of a member or members matching a pattern
}
