% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPSD.R
\name{plotPSD}
\alias{plotPSD}
\alias{prepPSDData}
\title{Plot Power Spectral Density}
\usage{
plotPSD(
  x,
  style = c("quantile", "density"),
  scale = c("log", "linear"),
  q = 0.5,
  color = "black",
  freqRange = NULL,
  dbRange = NULL,
  dbInt = 1,
  densityRange = NULL,
  units = "dB re: 1uPa^2/Hz",
  cmap = viridis_pal()(25),
  by = NULL,
  referenceLevel = NULL,
  facet = NULL,
  ncol = NULL,
  title = NULL,
  returnData = FALSE,
  progress = TRUE
)

prepPSDData(
  x,
  freqRange = NULL,
  style = c("density", "quantile"),
  by = NULL,
  dbInt = 1,
  compression = 10000,
  progress = TRUE
)
}
\arguments{
\item{x}{a dataframe or list of dataframes, or file path or vector
of file paths, or the output from \code{prepPSDData}}

\item{style}{character specifying plot style to create, either
"quantile", "density", or a vector with both}

\item{scale}{scale to use for frequency axis, one of "log" or "linear"}

\item{q}{quantile to plot}

\item{color}{color for quantile}

\item{freqRange}{range of frequencies to plot}

\item{dbRange}{range of dB values to plot}

\item{dbInt}{bin interval size for density plot}

\item{densityRange}{optional range of values for density color scale}

\item{units}{units for dB axis of plot}

\item{cmap}{color map to use for density plot}

\item{by}{optional column to plot different quantile lines by, only affects
\code{style='quantile'}. If \code{x} is a data.frame, \code{by} can also
be one of \code{'hour'}, \code{'month'}, or \code{'year'} and that column
will be created automatically if not present.}

\item{referenceLevel}{only used together with \code{by}. A value of the
\code{by} column to use as a reference for all other levels. The plot
will then show the difference between the other levels and the reference}

\item{facet}{optional column to facet the plots by}

\item{ncol}{number of columns to use when plotting with \code{facet}}

\item{title}{optional title for plot}

\item{returnData}{if \code{TRUE} then no plot will be generated, instead the
dataframe that would normally be used to make the plot will be returned}

\item{progress}{logical flag to show progress bar}

\item{compression}{compression factor for \link[tdigest]{tdigest}, lower
values are less accurate but will compute faster. Only relevant for
\code{style='quantile'} when loading and combining multiple datasets}
}
\value{
a ggplot object for \code{plotPSD}, see details for \code{prepPSDData}
}
\description{
Plots the distribution of summarised sound levels
across frequency, either as lines of quantile levels or a
heatmap showing the full distribution. Multiple PSD sources
can be combined and plotted as long as they have identical
frequency levels.
}
\details{
\code{prepPSDData} is called by the plotting code, and
does not necessarily need to be called separately from
\code{plotPSD}. Loading PSD data can be time consuming, so
it may be useful to load the data first, then it is easier
to spend time adjusting plot settings.

The output of \code{prepPSDData} is a list with 5 elements:
\describe{
\item{frequency}{ - the frequency values of the input data}
\item{freqRange}{ - the value of the "freqRange" parameter if
it was supplied}
\item{dbVals}{ - the dB values of breakpoints used for "density"
plotting}
\item{quantileData}{ - the data used for quantile plots. These
are stored as "tidgest" objects serialized using
\link[tdigest]{as.list.tdigest}, from which quantiles can
be computed}
\item{densityData}{ - the data used fro quantile plots. These
are stored as a matrix of bin counts - each column corresponds
to the "frequency" output, each row corresponds to bins defined
using "dbVals" as boundaries}
}
}
\examples{

psd <- loadSoundscapeData(system.file('extdata/PSDSmall.csv', package='PAMscapes'))
# Plotting only first 1000 columns for brevity
plotPSD(psd[1:1000], style='density')
plotPSD(psd[1:1000], style='quantile', q=.05)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
