% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization.R
\name{norm_internal_assay_median}
\alias{norm_internal_assay_median}
\title{Compute median value of the quantification method for each Olink assay}
\usage{
norm_internal_assay_median(df, samples, name, cols)
}
\arguments{
\item{df}{The dataset to calculate medians from (required).}

\item{samples}{Character vector of sample identifiers to be used for
adjustment factor calculation in the dataset \code{df} (required).}

\item{name}{Project name of the dataset that will be added in the column
\code{Project} (required).}

\item{cols}{Named list of column names identified in the dataset \code{df}
(required).}
}
\value{
Tibble or ArrowObject with one row per Olink assay and the columns
OlinkID, Project, and assay_med
}
\description{
The function computes the median value of the the quantification method for
each Olink assay in the set of samples \code{samples}, and it adds the column
\code{Project}.
}
\details{
This function is typically used by internal functions
\code{\link{norm_internal_subset}} and
\code{\link{norm_internal_reference_median}} that compute median
quantification value for each assay across multiple samples specified by
\code{samples}.
}
\author{
Klev Diamanti
}
