% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{brain_litter_mammals_df}
\alias{brain_litter_mammals_df}
\title{Mammal Brain Size and Litter Size Relationship}
\format{
A data frame with 96 observations and 2 variables:
\describe{
  \item{BrainSize}{Numeric: Relative brain weight measurement (encephalization quotient or similar metric)}
  \item{LitterSize}{Factor with 2 levels: Reproductive strategy ("Small" (\eqn{< 2}) and "Large" (\eqn{\geq 2}) litter sizes)}
}
}
\source{
Data taken from the \pkg{Sleuth3} package version 1.0-6. Original reference:
Ramsey, F.L. and Schafer, D.W. (2002) \emph{The Statistical Sleuth: A Course in Methods
of Data Analysis} (2nd ed), Duxbury.
}
\usage{
data(brain_litter_mammals_df)
}
\description{
This dataset, \code{brain_litter_mammals_df}, is a data frame comparing relative brain weights
between 96 mammalian species divided by reproductive strategy: 51 species with small litters
(\eqn{< 2} offspring) and 45 species with large litters (\eqn{\geq 2} offspring).
}
\details{
The dataset name has been kept as \code{brain_litter_mammals_df} to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the \pkg{NeuroDataSets} package. The suffix \code{df} indicates
that the dataset is a data frame. The original content has not been modified.
}
