% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{alzheimer_smoking_df}
\alias{alzheimer_smoking_df}
\title{Smoking and Alzheimer's Disease}
\format{
A data frame with 538 observations and 3 variables:
\describe{
  \item{smoking}{Factor: Smoking status of participants (4 levels)}
  \item{disease}{Factor: Disease classification including Alzheimer's diagnosis (3 levels)}
  \item{gender}{Factor: Participant's gender (2 levels)}
}
}
\source{
Data taken from the coin package version 1.4-3. Original study:
Salib, E. and Hillier, V. (1997). A case-control study of smoking and Alzheimer's disease.
International Journal of Geriatric Psychiatry 12: 295-300.
}
\usage{
data(alzheimer_smoking_df)
}
\description{
This dataset, alzheimer_smoking_df, is a data frame containing case-control data
from a study examining the association between smoking and Alzheimer's disease.
The study included 538 participants with information on smoking status,
disease classification, and gender.
}
\details{
The dataset name has been kept as 'alzheimer_smoking_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the NeuroDataSets package. The suffix 'df' indicates
that the dataset is a data frame. The original content has not been modified.
}
