% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldNLR-classes-methods.R
\name{createWorld}
\alias{createWorld}
\alias{createWorld,numeric,numeric,numeric,numeric,ANY-method}
\alias{createWorld,missing,missing,missing,missing,missing-method}
\title{Create a \code{world}}
\usage{
createWorld(minPxcor, maxPxcor, minPycor, maxPycor, data = NA)

\S4method{createWorld}{numeric,numeric,numeric,numeric,ANY}(minPxcor, maxPxcor, minPycor, maxPycor, data = NA)

\S4method{createWorld}{missing,missing,missing,missing,missing}()
}
\arguments{
\item{minPxcor}{Integer. Minimum \code{pxcor} for the \code{patches} (\code{world}'s left border).}

\item{maxPxcor}{Integer. Maximum \code{pxcor} for the \code{patches} (\code{world}'s right border).}

\item{minPycor}{Integer. Minimum \code{pycor} for the \code{patches} (\code{world}'s bottom border).}

\item{maxPycor}{Integer. Maximum \code{pycor} for the \code{patches} (\code{world}'s top border).}

\item{data}{Vector of length 1 or length
\code{(maxPxcor - minPxcor + 1) * (maxPycor - minPycor + 1)}.
Default is \code{NA}.}
}
\value{
\code{WorldMatrix} object composed of
\code{(maxPxcor - minPxcor + 1) * (maxPycor - minPycor + 1)}
patches (i.e., matrix cells).
}
\description{
Create a \code{world} of \code{patches} of class \code{worldMatrix}.
}
\details{
If \code{data} is provided, values are assigned by rows.

\if{html}{\out{<div class="sourceCode">}}\preformatted{     If no parameters value are provided, default values are:
     `minPxcor = -16`,
     `maxPxcor = 16`, `minPycor = -16`, and `maxPycor = 16`.

     See `help("worldMatrix-class")` for more details on the `worldMatrix` class.
}\if{html}{\out{</div>}}
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4, data = 1:25)
plot(w1)

}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\author{
Sarah Bauduin, Eliot McIntire, and Alex Chubaty
}
