% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldNLR-classes-methods.R
\docType{methods}
\name{[[,worldArray,ANY,missing-method}
\alias{[[,worldArray,ANY,missing-method}
\alias{[[<-,worldArray,ANY,missing-method}
\alias{$}
\alias{$,worldArray-method}
\title{Subsetting and replacing for \code{worldArray} class}
\usage{
\S4method{[[}{worldArray,ANY,missing}(x, i)

\S4method{[[}{worldArray,ANY,missing}(x, i) <- value

\S4method{$}{worldArray}(x, name)
}
\arguments{
\item{x}{A \code{worldArray} object.}

\item{i}{Index number or layer name specifying a subset of layer(s)
from the \code{worldArray}.}

\item{value}{A replacement \code{worldMatrix} layer for one of the current layers in the
\code{worldArray}.}

\item{name}{Layer name, normally without back ticks, unless has symbols.}
}
\value{
The replacement method returns the original object, but with updated elements.
The accessor method extracts the entire layer.
}
\description{
Subsetting and replacing for \code{worldArray} class
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9, data = runif(100))
w2 <- createWorld(0, 9, 0, 9, data = runif(100))
w3 <- createWorld(0, 9, 0, 9, data = runif(100) + 2) # add 2 so different range
a1 <- stackWorlds(w1, w2)
a1[[2]]
a1[[2]] <- w3

}
