% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMDS.R
\name{runSimper}
\alias{runSimper}
\alias{runSimper.Ordination}
\alias{runSimper.default}
\title{Similarity Percentages Analysis}
\usage{
runSimper(object, ...)

\method{runSimper}{Ordination}(object, ...)

\method{runSimper}{default}(object, ...)
}
\arguments{
\item{object}{An object of class "Ordination".}

\item{...}{Additional arguments passed to \code{\link[vegan]{simper}}.}
}
\value{
The object of class "Ordination" containing (See \code{\link{runNMDS}} for details):
\itemize{
\item data - List containing the input data and group information
\item call - The function call
\item NMDS - NMDS results from \code{\link[vegan]{metaMDS}}
\item SIMPER - SIMPER results
}
}
\description{
Discriminating species between two groups using Bray-Curtis dissimilarities
}
\examples{
# Example with default Bray-Curtis distance
data <- data.frame(
  Cephalobus = c(10, 20, 30, 1, 6, 5),
  Eucephalobus = c(5, 10, 12, 30, 1, 6),
  Acrobeloides = c(1, 2, 3, 12, 30, 1),
  Caenorhabditis = c(5, 8, 15, 2, 3, 12),
  Aphelenchus = c(5, 13, 11, 15, 2, 3),
  Leptonchus = c(3, 10, 15, 0, 15, 11),
  Pratylenchus = c(9, 2, 15, 15, 0, 15),
  Tylenchus = c(5, 0, 15, 11, 15, 2),
  Mesodorylaimus = c(7, 10, 18, 3, 12, 30),
  Discolaimus = c(1, 10, 25, 10, 18, 3),
  row.names = c("Sample1", "Sample2", "Sample3", "Sample4", "Sample5", "Sample6")
)
group_df <- data.frame(
  group = c("A", "A", "B", "B", "C", "C"),
  row.names = c("Sample1", "Sample2", "Sample3", "Sample4", "Sample5", "Sample6")
)
nmds <- runNMDS(data, group = group_df, simper = FALSE)

# Example
nmds_simper <- runSimper(nmds)
print(nmds_simper$SIMPER)

}
