% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{PM.matrix}
\alias{PM.matrix}
\title{Partial Moment Matrix}
\usage{
PM.matrix(LPM_degree, UPM_degree, target, variable, pop_adj, norm = FALSE)
}
\arguments{
\item{LPM_degree}{numeric; lower partial moment degree (0 = freq, 1 = area).}

\item{UPM_degree}{numeric; upper partial moment degree (0 = freq, 1 = area).}

\item{target}{numeric vector; thresholds for each column (defaults to colMeans).}

\item{variable}{numeric matrix or data.frame.}

\item{pop_adj}{logical; TRUE adjusts population vs. sample moments.}

\item{norm}{logical; default FALSE. If TRUE, each quadrant matrix is cell-wise normalized so their sum is 1 at each (i,j).}
}
\value{
A list: $cupm, $dupm, $dlpm, $clpm, $cov.matrix.
}
\description{
Builds a list containing CUPM, DUPM, DLPM, CLPM and the overall covariance matrix.
}
\details{
Partial Moment Matrix
}
\examples{
set.seed(123)
A <- cbind(rnorm(100), rnorm(100), rnorm(100))
PM.matrix(1, 1, NULL, A, TRUE)          # uses norm = FALSE by default
PM.matrix(1, 1, NULL, A, TRUE, TRUE)    # enable normalization
}
