% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumOutputs.R
\name{ComputeGIRFs}
\alias{ComputeGIRFs}
\title{Compute GIRFs for all models}
\usage{
ComputeGIRFs(
  Sigma.y,
  F1,
  BLoad,
  G0.y,
  FactorLabels,
  FacDim,
  MatLength,
  GIRFhoriz,
  YieldsLabel,
  ModelType,
  Economy = NULL,
  PI = NULL,
  Mode = FALSE
)
}
\arguments{
\item{Sigma.y}{Variance-covariance matrix}

\item{F1}{Feedback matrix}

\item{BLoad}{Loading Bs}

\item{G0.y}{matrix of contemporaneous terms}

\item{FactorLabels}{List containing the labels of the factors}

\item{FacDim}{Dimension of the P-dynamics}

\item{MatLength}{Length of the maturity vector}

\item{GIRFhoriz}{Horizon of the analysis}

\item{YieldsLabel}{Label o yields}

\item{ModelType}{desired Model type}

\item{Economy}{Economy under study}

\item{PI}{matrix PI for JLL-based models}

\item{Mode}{allows for the orthogonalized version in the case of JLL-based models

#' @references
\itemize{
\item This function is a partially based on the version of the "irf" function from
Smith, L.V. and A. Galesi (2014). GVAR Toolbox 2.0, available at https://sites.google.com/site/gvarmodelling/gvar-toolbox.

\item Pesaran and Shin, 1998. "Generalized impulse response analysis in linear multivariate models" (Economics Letters)
}}
}
\description{
Compute GIRFs for all models
}
\keyword{internal}
