% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Movement_calcs.R
\name{simmov2}
\alias{simmov2}
\title{Calculates movement matrices from user specified distribution among other areas}
\usage{
simmov2(
  OM,
  dist = c(0.05, 0.6, 0.35),
  distE = 0.01,
  frac_other = matrix(c(NA, 2, 1, 3, NA, 1, 1, 4, NA), nrow = 3, byrow = T),
  frac_otherE = 0.01,
  prob = 0.8,
  probE = 1,
  figure = TRUE
)
}
\arguments{
\item{OM}{Operating model, an object of class \linkS4class{OM}.}

\item{dist}{A vector of fractions of unfished stock in each area. The length of this vector will determine the
number of areas (\code{nareas}) in the OM.}

\item{distE}{Logit (normal) St.Dev error for sampling desired fraction in each area}

\item{frac_other}{A matrix (nareas rows from, nareas columns to) of relative fractions moving to other areas (the positive diagonal (staying) is unspecified).}

\item{frac_otherE}{Logit (normal) St.Dev error for sampling desired fraction moving to other areas.}

\item{prob}{the mean probability of staying in the same area among all areas}

\item{probE}{Logit (normal) St.Dev error for sampling desired probability of staying in each area}

\item{figure}{Logical to indicate if the movement matrix will be plotted (mean values and range
across \code{OM@nsim} simulations.)}
}
\value{
The operating model \code{OM} with movement parameters in slot \code{cpars}.
The \code{mov} array is of dimension \code{nsim}, \code{maxage}, \code{nareas}, \code{nareas}.
}
\description{
A wrapper function for \link{makemov2} used to generate movement matrices for the operating model.
Calculates a movement matrix from user-specified relative movement to other areas and probability of
staying in the area in each time step.
}
\section{Functions}{
\itemize{
\item \code{simmov2()}: Estimation function for creating movement matrix.

}}
\note{
Array \code{mov} is age-specific, but currently the movement generated by \code{simmov} is
independent of age.
}
\examples{
\dontrun{
movOM_3areas <- simmov2(testOM, frac_other = matrix(c(NA,2,1, 2,NA,1, 1,2,NA),
nrow=3, byrow=T), frac_otherE = 0.01, prob = 0.8, probE = 0.3)
# sim 1, age 1, movement from areas in column i to areas in row j
movOM_3areas@cpars$mov[1, 1, , ] 
plot_mov(movOM_3areas@cpars$mov)
plot_mov(movOM_3areas@cpars$mov, type = "all")

}
}
\author{
T. Carruthers and Q. Huynh
}
