% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.mrmc}
\alias{summary.stmc}
\title{Summary Estimates and Statistical Tests}
\usage{
\method{summary}{mrmc}(object, conf.level = 0.95, ...)

\method{summary}{stmc}(object, conf.level = 0.95, ...)
}
\arguments{
\item{object}{object to summarize.}

\item{conf.level}{confidence level for confidence intervals.}

\item{...}{additional arguments affecting the summary.}
}
\value{
The respective method functions return \code{summary.mrmc} and
\code{summary.stmc} class objects.

Object \code{summary.mrmc} is a list of the following elements.
\describe{
  \item{data_name}{character name of the original data frame supplied for the
    analysis.}
  \item{cov_method}{character name of the covariance method.}
  \item{design}{experimental study design: 1 = factorial, 2 = cases nested
    within readers, 3 = cases nested within tests.}
  \item{vars}{character names of the analysis factors and reader performance
    metric.}
  \item{conf.level}{numeric confidence interval level.}
  \item{vcov_comps}{data frame of estimated variances, covariances, and
    correlations.}
  \item{test_equality}{data frame of the ANOVA global test of equality.}
  \item{test_diffs}{data frame of pairwise test differences.}
  \item{test_means}{data frame of estimated test means.}
  \item{reader_test_diffs}{data frame of (fixed) reader-specific pairwise
    test differences.}
  \item{reader_means}{data frame of (fixed) reader-specific test means.}
}

Object \code{summary.stmc} is a numeric vector of the estimated reader
performance mean, standard error, lower confidence limit, and upper
confidence limit.
}
\description{
Summary estimates and statistical tests from single and multi-reader
multi-case analyses.
}
\seealso{
\code{\link{mrmc}}, \code{\link{srmc}}, \code{\link{stmc}}
}
