% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_converters.R
\name{combined_file_system}
\alias{combined_file_system}
\title{Combine train and test filesystem into single folder}
\usage{
combined_file_system(
  path_to_folders,
  file_ext,
  train_folder = "train",
  test_folder = "test",
  overwrite = FALSE
)
}
\arguments{
\item{path_to_folders}{path containing test and train folders; files will be
moved here}

\item{file_ext}{file extension to filter}

\item{train_folder}{train folder subdirectory name}

\item{test_folder}{test folder subdirectory name}

\item{overwrite}{force overwrite of files that already exist}
}
\value{
Logical vector, indicated success or failure for each file
}
\description{
This function reorganises files that have been split into train and test
directories using train_test_filesystem() back into a single directory.
This is a convenience function to reverse the effects of
train_test_filesystem().
}
\examples{
set.seed(123)
# create 10 random DNA files
tmp_dir <- tempdir()
# remove any existing .fna files
file.remove(
 list.files(tmp_dir, pattern = "*.fna", full.names = TRUE)
)
for (i in 1:10) {
writeLines(paste0(">", i, "\n", paste0(sample(c("A", "T", "C", "G"),
  100, replace = TRUE), collapse = "")), file.path(tmp_dir, paste0(i, ".fna")))
}

# split files into train and test directories
paths <- train_test_filesystem(tmp_dir,
                               file_ext = "fna",
                               split = 0.8,
                               shuffle = TRUE,
                               overwrite = TRUE)
# combine files back into a single directory
combined_file_system(tmp_dir, "fna")
list.files(tmp_dir)
}
